<?php

namespace Discovereel\Reels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Reel extends Model 
{

    protected $table = 'reels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function avatar()
    {
        return $this->belongsTo('Avatar');
    }

    public function theme()
    {
        return $this->belongsTo('Theme');
    }

    public function objetcs()
    {
        return $this->hasMany('Object');
    }

}